﻿using System.Collections.Generic;
using NVCC.Models;

namespace NVCC.WebUI.Infrastructure
{
    public class FakeUserService : IUserService
    {
        public NVCC.Models.ViaUser GetViaUser(string id, string password, string station, short sta3n)
        {
            return FakeDataManager.GetViaUser(true);
        }

        public NVCC.Models.ViaUser GetViaUser(short sta3n)
        {
            return FakeDataManager.GetViaUser(true);
        }

        public NVCC.Models.StationInfo GetStationInfo(short station)
        {
            return FakeDataManager.GetStationInfo();
        }

        public void SaveStationInfo(StationInfo stationInfo)
        {
            FakeDataManager.SetStationInfo(stationInfo);
        }

        public IEnumerable<Division> GetDivisions(int station)
        {
            return FakeDataManager.GetDivisions();
        }

        public Division GetDivision(string sta6a)
        {
            return FakeDataManager.GetDivision();
        }

        public User GetUser()
        {
            return FakeDataManager.GetUser(5);
        }

        public void UpdateUserFacility(User user)
        {
        }
    }
}